<?php

/**
 * Sanaprassi theme template redirects and overrides.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 * @package Sanaprassi
 *
 */




// Disable all templates, replace with only default template
function disable_all_page_templates($page_templates, $theme, $post, $post_type)
{
	_log_to_console("DISABLING TEMPLATES");
	return array('default' => 'Default Template');
}
add_filter('theme_page_templates', 'disable_all_page_templates', 10, 4);

/**
 * Helper: load our single template content.
 *
 * @return string|false Template content or false if not found.
 */
if (! function_exists('tr_load_single_template_content')) :
function tr_load_single_template_content($template_type = 'sanaprassi//index')
{
	_log_to_console("LOADING SINGLE TEMPLATE CONTENT");
	if ($template_type == 'sanaprassi//index') {
		$path = get_stylesheet_directory() . '/templates/index.html';
		if (file_exists($path)) {
			_log_to_console("TEMPLATE FOUND AT: " . $path);
			return file_get_contents($path);
		}
	} elseif ($template_type == 'sanaprassi//single') {
		$path = get_stylesheet_directory() . '/templates/single.html';
		if (file_exists($path)) {
			_log_to_console("TEMPLATE FOUND AT: " . $path);
			return file_get_contents($path);
		}
	} else {
		_log_to_console("TEMPLATE TYPE NOT MATCHING");
		$path = get_stylesheet_directory() . '/templates/index.html';
		return file_get_contents($path);
	}
	_log_to_console("TEMPLATE NOT FOUND");

	return false;
}
endif;



/**
 * Short-circuit the block template lookup early (front-end + editor).
 * Return a WP_Block_Template object with our content if needed.
 */
if (! function_exists('sprssi_pre_get_block_template')) :
    function sprssi_pre_get_block_template($block_template, $template_type, $post) {
		_log_to_console("PRE GET BLOCK TEMPLATE FILTER TRIGGERED");
		_log_to_console($block_template);
		_log_to_console($template_type);
		_log_to_console($post);
        $content = tr_load_single_template_content($template_type);
        if (! $content) {
            return $block_template;
        } else {
			$bt = new WP_Block_Template();
			$bt->type    = 'wp_template';
			$bt->theme   = get_stylesheet();
			$bt->slug    = $template_type === 'sanaprassi//single' ? 'single' : 'index';
			$bt->id      = $bt->theme . '//' . $bt->slug;
			$bt->title   = 'Forced Template';
			$bt->source  = 'theme';
			$bt->content = $content;
        
        return $bt;
		}
        
        // Prepare a WP_Block_Template object with our content.
        // If $block_template is already provided, just overwrite its content.
        if ($block_template instanceof WP_Block_Template) {
			_log_to_console("USING EXISTING BLOCK TEMPLATE");
            $block_template->content = $content;
            // Mark id/theme/slug as from current theme so core singular-handling runs.
            $block_template->id    = get_stylesheet() . '//' . ($block_template->slug ?: 'index');
            $block_template->theme = get_stylesheet();
            return $block_template;
        }
        
        
    };
endif;
add_filter('pre_get_block_template', 'sprssi_pre_get_block_template', 10, 3);
    
/**
 * Also alter the resolved template after normal lookup (extra safety).
 */
if (! function_exists('sprssi_alter_block_template')) :
function sprssi_alter_block_template($block_template, $id, $template_type) {
	_log_to_console("ALTER BLOCK TEMPLATE FILTER TRIGGERED");
    $content = tr_load_single_template_content();
	if (! $content) {
        return $block_template;
	}
	if ($block_template instanceof WP_Block_Template) {
        $block_template->content = $content;
		// Ensure the id looks like a theme template so singular loop logic can apply.
		$block_template->id    = get_stylesheet() . '//' . ($block_template->slug ?: 'index');
		$block_template->theme = get_stylesheet();
		return $block_template;
	}
    
	$bt = new WP_Block_Template();
	$bt->type    = 'wp_template';
	$bt->theme   = get_stylesheet();
	$bt->slug    = 'index';
	$bt->id      = $bt->theme . '//' . $bt->slug;
	$bt->title   = 'Forced Index';
	$bt->source  = 'theme';
	$bt->content = $content;
    
	return $bt;
};
endif;
add_filter('get_block_template', "sprssi_alter_block_template", 10, 3);

// Restrict to only use the Index template
/* add_filter('theme_templates', 'sanaprassi_restrict_templates', 10, 4);
function sanaprassi_restrict_templates($templates, $theme, $post, $post_type)
{
	_log_to_console("TEMPLATES:");
	_log_to_console($templates);
	// Only allow the index template for all post types
	$allowed_templates = array(
		'index' => $templates['index'],
	);

	return $allowed_templates;
} */
// Force all pages and posts to use index template

/* add_filter('template_include', 'sanaprassi_force_index_template');
function sanaprassi_force_index_template($template)
{
	// Get the theme directory
	$theme_dir = get_template_directory();
	// Check if index.html exists in templates folder
	if (file_exists($theme_dir . "/templates/" . $template)) {
		$template = $theme_dir . "/templates/" . $template;
		_log_to_console("FORCING TEMPLATE TO: " . $template);
	} else {
		_log_to_console("TRYING TO GET" . $template);
	}

	return $template;
} */




