<?php
// create custom plugin settings menu
add_action('admin_menu', 'sprssi_create_menu');

function sprssi_create_menu()
{

    //create new top-level menu
    //add_menu_page('Sanaprässi Settings', __('Sanaprässin asetukset', 'sanaprassi'), 'administrator', __FILE__, 'sprssi_settings_page', 'dashicons-admin-generic');
    //add_submenu_page('options-general.php', __('General settings', 'sanaprassi'), __('General settings', 'sanaprassi'), 'administrator', get_template_directory() . '/custom-settings.php', '', 0);
    add_submenu_page('options-general.php', __('Sanaprässin asetukset', 'sanaprassi'), __('Sanaprässi-teeman asetukset', 'sanaprassi'), 'administrator', 'sprssi_settings', 'sprssi_settings_page', 1);

    //call register settings function
    add_action('admin_init', 'register_sprssi_settings');
}

// Include the options in the same dir as this
include_once dirname(__FILE__) . '/sprssi_options.php';

// Load the version from info.json


if (!function_exists('register_sprssi_settings')) :
function register_sprssi_settings()
{
    //register our settings
    add_option(sprssi_options::$allow_posts, '0');
    add_option(sprssi_options::$debug_mode, '0');
    add_option(sprssi_options::$default_content_deleted, '0');
    add_option(sprssi_options::$htaccess_rules_added, '0');
    add_option(sprssi_options::$settings_set, '0');
    add_option(sprssi_options::$front_page_setup_done, '0');
    add_option(sprssi_options::$custom_css_set, '0');
    add_option(sprssi_options::$dev_env, '0');
    $info = json_decode(file_get_contents(dirname(__FILE__) . '/info.json'), true);
    if ($info && isset($info['version'])) {
        add_option(sprssi_options::$version, $info['version']);
    }

    
    register_setting('sprssi-settings-group', sprssi_options::$allow_posts);
    register_setting('sprssi-settings-group', sprssi_options::$debug_mode);
    register_setting('sprssi-settings-group', sprssi_options::$default_content_deleted);
    register_setting('sprssi-settings-group', sprssi_options::$htaccess_rules_added);
    register_setting('sprssi-settings-group', sprssi_options::$settings_set);
    register_setting('sprssi-settings-group', sprssi_options::$front_page_setup_done);
    register_setting('sprssi-settings-group', sprssi_options::$custom_css_set);
    register_setting('sprssi-settings-group', sprssi_options::$dev_env);
}
endif;

if (!function_exists('sprssi_deactivation_cleanup')) :
function sprssi_deactivation_cleanup()
{
	delete_option(sprssi_options::$debug_mode);
	delete_option(sprssi_options::$default_content_deleted);
	delete_option(sprssi_options::$htaccess_rules_added);
    delete_option(sprssi_options::$allow_posts);
    delete_option(sprssi_options::$settings_set);
    delete_option(sprssi_options::$front_page_setup_done);
    delete_option(sprssi_options::$custom_css_set);
    delete_option(sprssi_options::$dev_env);
}
endif;
register_deactivation_hook(__FILE__, 'sprssi_deactivation_cleanup');



function gen_option_row_for_yesno($option_name, $label_text)
{
    $option_value = get_option($option_name);
?>
    <tr valign="top">
        <th scope="row"><?php echo esc_html($label_text); ?></th>
        <td>
            <select name="<?php echo esc_attr($option_name); ?>" value="<?php echo esc_attr($option_value); ?>">
                <option value="0" <?php selected($option_value, "0"); ?>><?php _e('Ei', 'sanaprassi'); ?></option>
                <option value="1" <?php selected($option_value, "1"); ?>><?php _e('Kyllä', 'sanaprassi'); ?></option>
            </select>
        </td>
    </tr>
<?php
}




function gen_reset_for_setting($setting_name, $button_text)
{
    $option_value = get_option($setting_name);
    if (isset($_POST['reset_' . $setting_name])) {
        update_option($setting_name, '0');
        echo '<div class="updated"><p>' . __('Asetus on nollattu.', 'sanaprassi') . '</p></div>';
    }
    ?>
    <form method="post" action="">
        <input type="hidden" name="reset_<?php echo esc_attr($setting_name); ?>" value="0" />
        <?php submit_button(esc_html($button_text), 'secondary'); ?>
    </form>
<?php
}


function gen_version_span()
{
    $version = get_option(sprssi_options::$version);
    if ($version) {
        return '<span class="sprssi-version">Versio: ' . esc_html($version) . '</span>';
    }
}


function sprssi_settings_page()
{
?>
    <div class="wrap">
        <h1><?php _e('Asetukset', 'sanaprassi'); ?></h1>
        <p><?php _e('Täällä on Mikaelin luoman Sanaprässi-teeman asetukset. Jos jostakin syystä haluat saada näkyviin koko Wordpress-hallintapaneelin, voit tehdä sen täältä asettamalla "Debug-tila", ja "Salli artikkeliblokit" -asetukset päälle.', 'sanaprassi'); ?></p>
        <p><?php _e('Teema on siis eräänlainen wordpress-lisäosa, joka muokkaa tätä wordpress-hallintapaneelia. Täältä on poistettu sellaisia asetuksia, jotka eivät ole välttämättömiä ja jotka saattavat vain aiheuttaa hämmennystä.', 'sanaprassi'); ?></p>
        <?php echo gen_version_span(); ?>

        <form method="post" action="options.php">
            <?php settings_fields('sprssi-settings-group'); ?>
            <?php do_settings_sections('sprssi-settings-group'); ?>
            <table class="form-table">
            
                
                <?php gen_option_row_for_yesno(sprssi_options::$debug_mode, __('Ota debug-tila käyttöön', 'sanaprassi')); ?>
                <?php gen_option_row_for_yesno(sprssi_options::$allow_posts, __('Salli artikkeliblokit', 'sanaprassi')); ?>
                <?php gen_option_row_for_yesno(sprssi_options::$custom_css_set, __('Sanaprässin CSS asetettu', 'sanaprassi')); ?>
            </table>

            <?php submit_button(); ?>
        </form>
        <h2><?php _e('Nollaa asetukset', 'sanaprassi'); ?></h2>
        <span style="color: tomato;"><?php _e('Ole varovainen näiden kanssa. Jos et tiedä, kysy Mikaelilta.', 'sanaprassi'); ?></span>
        <div>
            <?php gen_reset_for_setting(sprssi_options::$htaccess_rules_added, __('Nollaa .htaccess-säännöt', 'sanaprassi')); ?>
            <?php gen_reset_for_setting(sprssi_options::$default_content_deleted, __('Nollaa oletussisällön poisto', 'sanaprassi')); ?>
            <?php gen_reset_for_setting(sprssi_options::$settings_set, __('Nollaa aloitusasetukset', 'sanaprassi')); ?>
            <?php gen_reset_for_setting(sprssi_options::$front_page_setup_done, __('Nollaa etusivun asetus', 'sanaprassi')); ?>
        </div>
    </div>

    
<?php } ?>